package pt.caf_pbs.schooldiskapi.controller;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.server.ResponseStatusException;
import pt.caf_pbs.schooldiskapi.dao.FilesOperation;
import pt.caf_pbs.schooldiskapi.dto.SchoolDTO;
import pt.caf_pbs.schooldiskapi.model.*;

import java.util.Optional;

@RestController
@RequestMapping("/v1/school")
public class SchoolController {
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SchoolController.class);

    @GetMapping("version")
    public String getVersion() {
        return "School disk API. V1.0.0";
    }

    @GetMapping()
    public School getSchool() {
        School school = FilesOperation.loadSchool();//todo: remover o detalhe dos instrutores (remover lectures) e averiguar se filtro subjects. enrolls acho que está bom
        return school;
    }

    @PostMapping("restore")
    public School restoreSchool() {
        School school = FilesOperation.restoreSchool();
        return school;
    }
}
